
import java.util.*;
import java.io.*;
import java.net.*;

/*  Stolen From Dexdyne, klb, August 2002.
    This class implements an interface between the JVM-resident daemon on the WebView
    and an arbitary Java program that wishes to control an OCS100 box.
    
    It provides methods that allow interactive control of motor and sense functions of the
    box via the Java-based daemon and seriald.
 */

public class MBIPCl
{
private int REGISTER_BLOCK_TYPE     = 0;
private int REGISTER_BLOCK_START    = 0;
private int REGISTER_BLOCK_SIZE     = 10;

	boolean active = false;
	private Socket _con;
	private InputStream _in;
	private OutputStream _out;
	private InputStreamReader _isr;
	private BufferedReader _br;
	private PrintWriter _pw;

	private String _server;
    private String sHostName;
	private int _port;

    private short   []   nRegVal    = new short[100];

    public MBIPCl() 
    {
		// This constructor does nothing.
		active = false;
	}

    public MBIPCl(String host) 
    {
        sHostName   = host;

        open();
	}

    public  void    open()
    {
		// This constructor does something.
		active = false;
        _server = sHostName;
        _port = 502;
		
		_con = null;
		_in = null;
		_out = null;
		_isr = null;
		_br = null;
		_pw = null;
		
		try
		{
            System.err.println("Starting Modbus TCP/IP");
			_con = new Socket(_server, _port);
            _con.setSoTimeout(500);  // milliseconds

			_in = _con.getInputStream();
			_out = _con.getOutputStream();
			
			_isr = new InputStreamReader(_in);
			_br = new BufferedReader(_isr);
			_pw = new PrintWriter(_out);
		}
		catch (Exception e2)
		{
			System.err.println("Error in network: "+e2.getMessage());
		}

		if (_con != null)
		   active = true;

    }

    public  short   GetRegister(int nId)
    {
        if(nId == -1)
        {
            ReadBlock(1, REGISTER_BLOCK_TYPE, REGISTER_BLOCK_START,
                REGISTER_BLOCK_SIZE, nRegVal);

            return 0;
        }
        else
            return nRegVal[nId];
    }

    public  void   SetRegister(int nId, short nValue)
    {
        short   []  nRegVal = new short[1];

        nRegVal[0]          = nValue;

        WriteBlock(1, REGISTER_BLOCK_TYPE, nId, 1, nRegVal);
    }

    private boolean ReadBlock(int nUI, int nRegType, int nFirstReg, int nTotalRegs, short[] nStore)
	{
		if(!active)
            return(false);

        nFirstReg += 3000;                          // Cscape Rs Offset

        byte[]      request = new byte[12];

        request[0]  = 0;                            // Transaction Identifier - HIGH BYTE
        request[1]  = 0;                            // Transaction Identifier - LOW BYTE
        request[2]  = 0;                            // Protocol Identifier - HIGH BYTE
        request[3]  = 0;                            // Protocol Identifier - LOW BYTE
        request[4]  = 0;                            // Length Field - High Byte of 6
        request[5]  = 6;                            // Length Field - Low Byte of 6
        request[6]  = (byte) nUI;                   // Unit Identifier
        request[7]  = 3;                            // Function Code 3 for Holding Registers
        request[8]  = (byte) (nFirstReg / 256);     // Base Register High Byte
        request[9]  = (byte) (nFirstReg % 256);     // Base Register Low Byte
        request[10] = (byte) (nTotalRegs / 256);    // Total Registers High Byte
        request[11] = (byte) (nTotalRegs % 256);    // Total Registers Low Byte

        byte[]      response = new byte[256];

		try {
            _out.write(request, 0, 12);
            _out.flush();

            int reply = _in.read(response, 0, 256);

            if(response[0] != 0 || response[1] != 0 || response[2] != 0 || response[3] != 0)
            {
                System.err.println("Failed 0");

                return(false);
            }

            if(response[4] != 0 || response[5] != (3 + nTotalRegs * 2))
            {
                System.err.println("Failed 1");

                return(false);
            }


            if(response[6] != request[6] || response[7] != request[7])
            {
                System.err.println("Failed 2");

                return(false);
            }


            if(response[8] != (nTotalRegs * 2))
            {
                System.err.println("Failed 3");

                return(false);
            }

            for(int nCopy = 0;  nCopy < nTotalRegs; nCopy++)
                nStore[nCopy] = (short)(((response[nCopy + nCopy + 9] << 8) & 0xFF00) + (response[nCopy + nCopy + 10] & 255));

            return(true);
   		}

   		catch (Exception e)
   	    {
   	    	System.err.println(e.getMessage());	

            close();
            open();
   	    }

        return(false);
	}
	
    private boolean WriteBlock(int nUI, int nRegType, int nFirstReg, int nTotalRegs, short[] nStore)
    {
		if(!active)
            return(false);

        nFirstReg += 3000;                          // Cscape Rs Offset

        byte[]      request = new byte[256];

        request[0]  = 0;                            // Transaction Identifier - HIGH BYTE
        request[1]  = 0;                            // Transaction Identifier - LOW BYTE
        request[2]  = 0;                            // Protocol Identifier - HIGH BYTE
        request[3]  = 0;                            // Protocol Identifier - LOW BYTE
        request[4]  = 0;                            // Length Field - High Byte of 6
        request[5]  = (byte) (nTotalRegs * 2 + 5);  // Length Field - Low Byte of 6
        request[6]  = (byte) nUI;                   // Unit Identifier
        request[7]  = 16;                           // Function Code 16
        request[8]  = (byte)(nFirstReg >> 8 & 255); // Base Register High Byte
        request[9]  = (byte)(nFirstReg >> 0 & 255); // Base Register Low Byte
        request[10] = (byte)(nTotalRegs>> 8 & 255); // Total Registers High Byte
        request[11] = (byte)(nTotalRegs>> 0 & 255); // Total Registers Low Byte
        request[12] = (byte)(nTotalRegs * 2);       // Length Field - Low Byte of 6

        for(int nCopy = 0;  nCopy < nTotalRegs; nCopy++)
        {
            request[13 + nCopy + nCopy] = (byte) (nStore[nCopy] >> 8 & 255);
            request[14 + nCopy + nCopy] = (byte) (nStore[nCopy] >> 0 & 255);
        }

        byte[]      response = new byte[256];

		try {
            _out.write(request, 0, nTotalRegs * 2 + 13);
            _out.flush();

            int reply = _in.read(response, 0, 256);

            if(response[0] != 0 || response[1] != 0 || response[2] != 0 || response[3] != 0)
                return(false);

            if(response[4] != 0 || response[5] != 5)
                return(false);

            if(response[6] != request[6] || response[7] != request[7])
                return(false);

            if(response[8] != request[8] || response[9] != request[9])
                return(false);

            if(response[10] != request[10] || response[11] != request[11])
                return(false);

            return(true);
   		}

   		catch (Exception e)
   	    {
   	    	System.err.println(e.getMessage());	
   	    }

        return(false);

	}
	
	public void close()
	{
		try
		{
			String s = new String("QUIT");  // Close the port.
			
			_pw.println(s);
			_pw.flush();

			_con.close();
			_con = null;
		}
		catch (IOException ioe)
		{
			System.out.println("Closing socket failed: "+ioe.getMessage());	
		}
	}
	
	/**
    Flushes the output to the serial daemon
	*/
	public void flushOutput()
	{
		_pw.flush();
	}
	
	/**
	Returns true if this SerialDaemon has been closed.
	@return 	true if closed
	*/
	public boolean isClosed()
	{
		return (_con == null);
	}

	/**
	Returns true if there is any data waiting to be read
	@return		boolean		true if there is data waiting
	*/
	public boolean dataWaiting() throws IOException   // Checks to see if there is data waiting.
	{
        return (_in.available() > 0); 
	}

}
