import java.awt.*;
import java.util.*;
import javax.swing.*;

public  class   RegPan  extends Panel
{
private Color   cButterscotch   = new Color(255, 204, 102);
private Color   cBlurg          = new Color(153, 102, 51);

private short   nId;

private short   nValue;

private short   nNewValue;

private MBIPCl  mbusTcpIp;

private short[] SendData        = new short[1];

    public  RegPan(MBIPCl Access, short nNewId)
    {
        nId     = nNewId;

        nValue  = -1;

        mbusTcpIp   = Access;

        setSize(200, 30);

        setBackground(cBlurg);
    }

    public  void    UpdateValue()
    {
        if (mbusTcpIp != null)
        {
            nNewValue   = mbusTcpIp.GetRegister(nId);

            if(nNewValue != nValue)
                repaint();
        }
    }

    public  void    paint(Graphics screen)
    {
        Graphics2D  screen2D    = (Graphics2D) screen;

        Font        type        = new Font("Monospaced", Font.BOLD, 20);

        screen2D.setFont(type);

/*
        screen2D.setColor(cBlurg);
        screen2D.drawString(sRegName() + ": " + nValue, 40, 22);
*/
        screen2D.setColor(cButterscotch);
        screen2D.drawString(sRegName() + ": " + nNewValue, 40, 22);

        nValue  = nNewValue;
    }

    public  void    Update(Graphics screen)
    {
        paint(screen);
    }

    public  String  sRegName()
    {
        return "%R" + (nId + 1) / 1000 % 10 
               + "" + (nId + 1) / 100 % 10 
               + "" + (nId + 1) / 10 % 10
               + "" + (nId + 1) % 10;
    }

    public boolean mouseDown(Event evtClick, int x, int y)
    {
        String  sNewValue   = JOptionPane.showInputDialog(null, "Enter New Value For " + sRegName());

        nNewValue  = (short) Integer.parseInt(sNewValue);

        System.err.println("Sending " + nNewValue);

        mbusTcpIp.SetRegister(nId, nNewValue);

        repaint();

        return true;
    }
}

