import java.awt.*;
import java.util.*;
import javax.swing.*;

public  class   Trend  extends Panel
{
private Color   cBlack      = new Color(0, 0, 0);
private Color   cPen        = new Color(255, 255, 255);

private short   nId;

private short   nLastValue, nValue;

private short[] Trend       = new short[100];
private int     YPos;

private short   nAddPoint   = 0;

private boolean bWrapped    = false;

private int     XPosition   = 20;

private MBIPCl  mbusTcpIp;

    public  Trend(MBIPCl Access, short nTrendId)
    {
        nId         = nTrendId;

        nLastValue  = 0;
        nValue      = 0;

        mbusTcpIp   = Access;

        setSize(200, 120);

        setBackground(cBlack);
    }

    public  void    UpdateTrend()
    {
        if (mbusTcpIp != null)
        {
            nValue  = mbusTcpIp.GetRegister(nId);

            if(nId == 8)
                nValue  = (short) (50 + nValue / 330);
            else
                nValue  = (short) (10 + nValue * 4);
        }

        Trend[nAddPoint++]  = nValue;

        if(nAddPoint >= 100)
        {
            bWrapped    = true;
            nAddPoint   = 0;
        }

        repaint();
    }

    public  void    paint(Graphics screen)
    {
        short       nAdd;

        Graphics2D  screen2D    = (Graphics2D) screen;

        Font        type        = new Font("Monospaced", Font.BOLD, 20);

        screen2D.setFont(type);

        screen2D.setColor(cBlack);
        screen2D.drawString(sRegName() + ": " + nLastValue, 60, 130);
        screen2D.setColor(cPen);
        screen2D.drawString(sRegName() + ": " + nValue, 60, 130);

        nLastValue  = nValue;

        screen2D.drawLine(  XPosition,       2, XPosition,       106);
        screen2D.drawLine(  XPosition - 4, 102, XPosition + 200, 102);

        for(int i = 1; i <= 10; i++)
            screen2D.drawLine(  XPosition + i * 20, 102, XPosition + i * 20, (i == 5 || i == 10) ? 106 : 104);

        for(int i = 0; i < 5; i++)
            screen2D.drawLine(  XPosition, 2 + i * 20, XPosition - ((i == 0) ? 4 : 2), 2 + i * 20);

        nAdd    = bWrapped ? nAddPoint : 0;

        YPos    = 101 - Trend[nAdd++];

        for(int i = 0; i < 99; i++)
        {
            if(nAdd >= nAddPoint && !bWrapped)
                break;

            if(nAdd >= 100)
                nAdd = 0;

            screen2D.drawLine(  XPosition + i + i, YPos, XPosition + 2 + i + i, 101 - Trend[nAdd]);

            YPos = 101 - Trend[nAdd++];
        }
    }

    public  void    Update(Graphics screen)
    {
        paint(screen);
    }

    public  String  sRegName()
    {
        return "%R" + (nId + 1) / 1000 % 10 
               + "" + (nId + 1) / 100 % 10 
               + "" + (nId + 1) / 10 % 10
               + "" + (nId + 1) % 10;
    }
}

